#version 140
#extension GL_EXT_gpu_shader4 : enable
//Fibonacci SwirlyMod01.fsh by jayjayjay
//https://www.shadertoy.com/view/4llSzB
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Created by Jason Yung - jayjayjay/2015
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.

#define steps 2
#define time iTime*2.0

float fib(float fib0, float fib1) {
    float next = 0.;
    float step = .1;
    for( int i = 0; i < steps; i++ ) {    
		next = fib0 + fib1;
        fib0 = fib1;
        fib1 = next;
    }
    return next;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 uv = gl_FragCoord.xy / iResolution.xy;
    uv -= .5;
    
    float r = length(uv);
    float theta = atan(-uv.y,-uv.x);

    r += fib(r*3.,theta+sin(time/8.))*cos(time/12.)/2.;
    
    float tX = r * cos(theta);
    float tY = r * sin(theta);
    
    gl_FragColor = texture2D(iChannel0, vec2(tX,tY)+.5);
}




